@break on
@TITLE Dialogic(R) Clean-up Utility Version 2.0

@REM
@REM Copyright (C) 2003-2007 Dialogic Corporation.  All Rights Reserved.
@REM All names, products, and services mentioned herein are the
@REM trademarks or registered trademarks of their respective
@REM organizations and are the sole property of their respective
@REM owners.

@REM Initialize internal flags and variables
@set DELETESELF=
@set DISKSCAN=
@set NOPROMPT=
@set DIALOGICDIR=
@set DIALOGICDRIVE=
@set DIALOGICDIRSPEC=
@set DIALOGICDATADIR=
@set DIALOGICDATADRIVE=
@set DIALOGICDATADIRSPEC=
@set NOTSTOPSNMP=

@REM Remember our name, and if called using a full pathname, the drive/directory
@set SELF=%~f0
@set MYORGDRV=%~d1
@set MYORGPWD=%cd%

@REM
@REM Customize the defines below for your local system configuration
@REM
@set MYDRIVE=%SystemDrive%
@set MYWINDIR=%WINDIR%
@set MYWININFDIR=%MYWINDIR%\inf
@set MYWINSYSDIR=%MYWINDIR%\system32
@set MYWINDRIVERSDIR=%MYWINSYSDIR%\drivers
@set MYUNINSTALLDIR=%MYDRIVE%\Program Files\InstallShield Installation Information
@set MYARCH=x64
@IF %PROCESSOR_ARCHITECTURE% == x86 (
@IF NOT DEFINED PROCESSOR_ARCHITEW6432 (
@REM OS is 32bit
@set MYARCH=x86
))
@IF %MYARCH% == x86 set MYWOW=
@IF %MYARCH% == x64 set MYWOW=\Wow6432Node

@REM
@REM	Location of regedit.exe
@REM
@set REGEDIT="%WINDIR%\regedit.exe"

@REM
@REM	Process command line arguments
@REM
:getargs

@REM break out of loop if no more command line options
@if "%1"=="" goto doneargs

@REM set flag to delete this batch file when execution is complete
@if "%1"=="-deleteself" set DELETESELF=1

@REM set flag to skip diskscan
@if /I "%1"=="-diskscan" set DISKSCAN=1

@REM set flag to execute cleanup without prompting user
@if "%1"=="-noprompt" set NOPROMPT=1

@REM set flag to skip stopping snmp
@if "%1"=="-notstopsnmp" set NOTSTOPSNMP=1

@REM allow caller to specify directory path of Dialogic software
@REM note that no checking of the specified directory is done because
@REM it is possible that it may not still exist.
@REM WARNING: Whatever directory is passed will be recursively deleted
@REM WARNING: Passing the wrong directory can be hazardous to your system
@REM WARNING: The directory path must be surrounded by double quotes
@if "%1"=="-dialogicdir" set NEEDMORE=1
@if "%1"=="-dialogicdir" set DIALOGICDIRSPEC=1
@if "%NEEDMORE%"=="1" shift
@if "%NEEDMORE%"=="1" set DIALOGICDIR=%~1
@if "%NEEDMORE%"=="1" set DIALOGICDRIVE=%~d1
@if "%NEEDMORE%"=="1" (
	@set NEEDMORE=0
	@shift
	@goto getargs
)

@if "%1"=="-dialogicdatadir" set NEEDMORE=1
@if "%1"=="-dialogicdatadir" set DIALOGICDATADIRSPEC=1
@if "%NEEDMORE%"=="1" shift
@if "%NEEDMORE%"=="1" set DIALOGICDATADIR=%~1
@if "%NEEDMORE%"=="1" set DIALOGICDATADRIVE=%~d1
@if "%NEEDMORE%"=="1" set NEEDMORE=0
@REM
@REM DO NOT PUT ANY CODE BETWEEN -dialogicdir and -dialogicdatadir PARSING AND THE FOLLOWING shift
@REM
@shift

@REM loop until all command line arguments are read
@goto getargs

:doneargs

@REM if the user specified a directory on the command line, then use it
@REM else assume the default location
if NOT "%DIALOGICDIRSPEC%"=="1" (
set DIALOGICDRIVE=%MYDRIVE%
IF %MYARCH% == x86 set DIALOGICDIR="%MYDRIVE%\Program Files\Dialogic\HMP"
IF %MYARCH% == x64 set DIALOGICDIR="%MYDRIVE%\Program Files (x86)\Dialogic\HMP"
)
if NOT "%DIALOGICDATADIRSPEC%"=="1" (
set DIALOGICDATADRIVE=%MYDRIVE%
set DIALOGICDATADIR=%MYDRIVE%\ProgramData\Dialogic\HMP)  

@REM Fax location is set after final DIALOGICDRIVE value is determined
@set FAX=%DIALOGICDRIVE%\Fax

@REM allow user to skip prompt - needed in case of automated clean-up invocation
@if "%NOPROMPT%"=="1" goto skipprompt

@cls
@echo This utility will search your disk for Dialogic files and delete
@echo them when found.  Some log files can be located in any directory and
@echo the search for these files may take several minutes, so please be patient.
@echo Enabling the Windows Indexing service will speed this process.
@echo.
@echo BEFORE USING THIS UTILITY, READ AND UNDERSTAND THE FOLLOWING WARNINGS:
@echo.
@echo 1. All Dialogic software must be uninstalled and the system rebooted
@echo    before running this utility.
@echo 2. Running this utility on a system which has installed Dialogic
@echo    software will render such software inoperable.
@echo 3. All files and directories under the %DIALOGICDIR% directory
@if "%DIALOGDATADIRSPEC%"=="1" (
@echo    and %DIALOGICDATADIR% directory)
@echo    hierarchy will be deleted.
@echo 4. If Windows or the Dialogic Software was installed in a directory
@echo    other than the default, then the definitions at the top of this utility
@echo    must be modified before it is run.
@echo.
@echo To abort execution of this utility, press Control-C now.
@echo Otherwise to run the utility,
@pause

:skipprompt
REM
REM Stop any installed Dialogic services or system
REM services which may cause Dialogic files to be in use
REM
net stop AnmChannelFactoryServer /Y 2>NUL
net stop AnmChannelServer /Y 2>NUL
net stop AnmLoggerServer /Y 2>NUL
net stop AnmSupplierServer /Y 2>NUL
net stop AntDetect /Y 2>NUL
net stop Boardserver /Y 2>NUL
net stop CTBusBroker /Y 2>NUL
net stop DetectorsProj /Y 2>NUL
net stop DebugAngel /Y 2>NUL
net stop Dialogic /Y 2>NUL
net stop DlgcAntares /Y 2>NUL
net stop DlgcDcm /Y 2>NUL
net stop DLGCDeviceMapper /Y 2>NUL
net stop DlgcH323 /Y 2>NUL
net stop Dlgcmcd /Y 2>NUL
net stop DlgcMemDoler /Y 2>NUL
net stop Dlgcmpd /Y 2>NUL
net stop DlgcS7Srv /Y 2>NUL
net stop DlgcSram /Y 2>NUL
net stop DlgcUpgrade /Y 2>NUL
net stop dlgH323 /Y 2>NUL
net stop DlgPnPObserverService /Y 2>NUL
net stop DM3Config /Y 2>NUL
net stop DM3InsightDrv /Y 2>NUL
net stop EventService /Y 2>NUL
net stop GammaFax /Y 2>NUL
net stop GlfxIsa /Y 2>NUL
net stop GlfxPci /Y 2>NUL
net stop Gloaddrv /Y 2>NUL
net stop IMRService /Y 2>NUL
net stop IPMedia /Y 2>NUL
net stop NamingService /Y 2>NUL
net stop RtfDispatcher /Y 2>NUL
if NOT "%NOTSTOPSNMP%"=="1" (
net stop SNMPTRAP /Y 2>NUL
net stop SNMP /Y 2>NUL
)
net stop Springware_temp /Y 2>NUL
net stop "INTEL HMP License Manager" /Y 2>NUL
net stop "INTEL HMP Media Server" /Y 2>NUL

%DIALOGICDATADRIVE%
cd \

REM Delete Dialogic data directory hierarchy and its contents
@set DIR=%DIALOGICDATADIR%
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

%DIALOGICDRIVE%
cd \

REM Delete Dialogic directory hierarchy and its contents
@if exist "%DIALOGICDIR%" attrib -r /d /s "%DIALOGICDIR%"
if exist "%DIALOGICDIR%" rmdir /q /s "%DIALOGICDIR%"

REM Delete FAX directory hierarchy and its contents
@set DIR=%FAX%
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete default RTF log file directory and its contents
@set DIR=%DIALOGICDRIVE%\rtflog
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" del /f /q "%DIR%"
if exist "%DIR%" rmdir "%DIR%"

REM Delete point release uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{0FC1D5E3-21B9-11D4-A580-00C04F35CB28}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete SR 6.0 cPCI FP1 uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{D43962D0-77A0-11D4-8F9D-00C04F35CB28}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete feature pack/SR 5.1.1 SP1 uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{E62BF0D9-BA88-4227-B079-F2E52100E446}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete SR 5.1.1 FP1 standalone SU uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{18D1CB58-7334-41BA-85BF-EF31C321CEBC}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete system release uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{4A6FA71B-C3AA-494D-8D5D-6B5A3C196946}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete HMP 1.0 and 1.1 uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{DF2FE966-3A24-429D-B11C-1AB13E2AD6D0}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete HMP 1.0 SP1 and FP1 uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{0FC1D5E3-21B9-11D4-A580-00C04F35CB28}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete HMP 1.1SU uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{E62BF0D9-BA88-4227-B079-F2E52100E446}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete HMP 1.3, 1.3SU, 2.0 and 2.0SU uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{4A6FA71B-C3AA-494D-8D5D-6B5A3C196946}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete SDK uninstall directory hierarchy and its contents (obsolete, never released)
@set DIR=%MYUNINSTALLDIR%\{57A6B857-C948-427F-979C-CB8AF5331A56}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete uninstall directory hierarchy for Global Protocols 4.0 and later
@set DIR=%MYUNINSTALLDIR%\{8C1C7C31-AE1E-4EA9-A108-80F23ED7AE1B}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Dialogic System Software folder from start menu
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel Dialogic System Software
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Dialogic System Software folder from start menu (SR 6.0 cPCI FP1 SU, SR 6.0 PCI SU and later)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel Dialogic System Release
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Dialogic System Software folder from start menu (win 6.0 cPCI FP1)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel Dialogic Release 6.0 cPCI
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Dialogic System Software folder from start menu (HMP 1.0)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel HMP 1.0
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Dialogic System Software folder from start menu (HMP 1.0 FP1 and SP1)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel NetStructure (TM) HMP 1.0 menu
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Dialogic System Software folder from start menu (HMP 1.1)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel HMP 1.1
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Dialogic System Software folder from start menu (HMP 1.3, 1.3SU, 2.0 and 2.0SU)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel NetStructure HMP
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Dialogic HMP folder from start menu (HMP 2.0SU, HMP 3.0 and HMP 3.0SU)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Dialogic HMP
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

@REM allow user to skip disk scan to delete log file in order to save time on large drives
@if NOT "%DISKSCAN%"=="1" goto skipdiskscan

REM Delete frustatus log files from all directories
@set FILE=frustatus.log
del /f /s "%FILE%" 2>NUL

REM Delete RTF error log files from all directories
@set FILE=rtferror.log
del /f /s "%FILE%" 2>NUL

:skipdiskscan

@REM Delete install log file
@REM Commented out to meet requirement that log file not be deleted
@REM @set FILE=%TEMP%\DlgcInstall.log 
@REM @if exist "%FILE%" attrib -r "%FILE%"
@REM if exist "%FILE%" del /f /s "%FILE%"

REM
REM
REM Delete files from %MYWINDIR%
REM
REM

REM Delete NCM ini file
@set FILE=%MYWINDIR%\NCM.ini
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pre-SR 6.0 System Release install log file
@set FILE=%MYWINDIR%\dlgcinst.txt 
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete old uninstall log files
@set FILE=%MYWINDIR%\dlgc_un*_log.ini
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete old PTR install log file
@set FILE=%MYWINDIR%\dlgcptr.log 
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete service pack install log file
@set FILE=%MYWINDIR%\dlgcservicepack.log 
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dialogic uninstall executable
@set FILE=%MYWINDIR%\dlgcunin.exe
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete GfdCp.exe 
@set FILE=%MYWINDIR%\GfdCp.exe 
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete GfdCpDm3.exe 
@set FILE=%MYWINDIR%\GfdCpDm3.exe 
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete SerialLd.bat 
@set FILE=%MYWINDIR%\SerialLd.bat 
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete uninst.exe
@set FILE=%MYWINDIR%\uninst.exe
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete uninstgc.exe
@set FILE=%MYWINDIR%\uninstgc.exe
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete gcunin.exe
@set FILE=%MYWINDIR%\gcunin.exe
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete RtfService.lck
@set FILE=%MYWINDIR%\Temp\RtfService.lck
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM
REM
REM Delete files from %MYWINSYSDIR%
REM
REM

REM Delete adl.dll file
@set FILE=%MYWINSYSDIR%\adl.dll
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete anm_debug log file
@set FILE=%MYWINSYSDIR%\anm_debug.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete anm_trace log file
@set FILE=%MYWINSYSDIR%\anm_trace.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ClusterPkg log files
@set FILE=%MYWINSYSDIR%\ClusterPkg.log.*
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete confslot log file
@set FILE=%MYWINSYSDIR%\confslot.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ctbbapi.log log file
@set FILE=%MYWINSYSDIR%\ctbbapi.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3bsp log file
@set FILE=%MYWINSYSDIR%\dm3bsp.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3fdspdll log file
@set FILE=%MYWINSYSDIR%\dm3fdspdll.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Genload log file
@set FILE=%MYWINSYSDIR%\Genload.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete merc log file
@set FILE=%MYWINSYSDIR%\merc.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete mnt log file
@set FILE=%MYWINSYSDIR%\mnt.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete dm3power log file
@set FILE=%MYWINSYSDIR%\power.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete boardserver log file
@set FILE=%MYWINSYSDIR%\boardserver.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete Bristart log file
@set FILE=%MYWINSYSDIR%\Bristart.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete Bristop log file
@set FILE=%MYWINSYSDIR%\Bristop
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete sctsassi log file
@set FILE=%MYWINSYSDIR%\sctsassi.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete StartDrv log file
@set FILE=%MYWINSYSDIR%\StartDrv.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete TSFLoad log file
@set FILE=%MYWINSYSDIR%\TSFLoad.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete AnmCommon.dll 
@set FILE=%MYWINSYSDIR%\AnmCommon.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmConsumerCproxy.dll 
@set FILE=%MYWINSYSDIR%\AnmConsumerCproxy.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmConsumerServer.dll 
@set FILE=%MYWINSYSDIR%\AnmConsumerServer.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmCproxy.dll 
@set FILE=%MYWINSYSDIR%\AnmCproxy.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmErrorMsgs.dll 
@set FILE=%MYWINSYSDIR%\AnmErrorMsgs.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmMsgServer.dll 
@set FILE=%MYWINSYSDIR%\AnmMsgServer.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmSupplierCproxy.dll 
@set FILE=%MYWINSYSDIR%\AnmSupplierCproxy.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete antcfg.dll 
@set FILE=%MYWINSYSDIR%\antcfg.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete antcflib.dll 
@set FILE=%MYWINSYSDIR%\antcflib.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete antldlib.dll 
@set FILE=%MYWINSYSDIR%\antldlib.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ANTNTF.dll 
@set FILE=%MYWINSYSDIR%\ANTNTF.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AntPciLib.dll 
@set FILE=%MYWINSYSDIR%\AntPciLib.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete boardserver.exe 
@set FILE=%MYWINSYSDIR%\boardserver.exe 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete brintf.dll 
@set FILE=%MYWINSYSDIR%\brintf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete cheetah.dll 
@set FILE=%MYWINSYSDIR%\cheetah.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete cllib.dll 
@set FILE=%MYWINSYSDIR%\cllib.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM ClusterPkg.log 
@set FILE=%MYWINSYSDIR%\ClusterPkg.log 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ConfigGamma.cpl 
@set FILE=%MYWINSYSDIR%\ConfigGamma.cpl 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ConfigGDK.cpl 
@set FILE=%MYWINSYSDIR%\ConfigGDK.cpl 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ConfigGenerator.dll 
@set FILE=%MYWINSYSDIR%\ConfigGenerator.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM confslot.log 
@set FILE=%MYWINSYSDIR%\confslot.log 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosEvent405.dll 
@set FILE=%MYWINSYSDIR%\CosEvent405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosEvent405d.dll 
@set FILE=%MYWINSYSDIR%\CosEvent405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosNaming405.dll 
@set FILE=%MYWINSYSDIR%\CosNaming405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosNaming405d.dll 
@set FILE=%MYWINSYSDIR%\CosNaming405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosProperty405.dll 
@set FILE=%MYWINSYSDIR%\CosProperty405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosProperty405d.dll 
@set FILE=%MYWINSYSDIR%\CosProperty405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosTime405.dll 
@set FILE=%MYWINSYSDIR%\CosTime405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosTime405d.dll 
@set FILE=%MYWINSYSDIR%\CosTime405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete counters.h 
@set FILE=%MYWINSYSDIR%\counters.h 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete counters.ini 
@set FILE=%MYWINSYSDIR%\counters.ini 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Csapi32x.dll 
@set FILE=%MYWINSYSDIR%\Csapi32x.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Csgui.dll 
@set FILE=%MYWINSYSDIR%\Csgui.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM ctbbapi.log 
@set FILE=%MYWINSYSDIR%\ctbbapi.log 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ctbbface.dll 
@set FILE=%MYWINSYSDIR%\ctbbface.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete d41mt.cnt 
@set FILE=%MYWINSYSDIR%\d41mt.cnt 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete d41mt.hlp 
@set FILE=%MYWINSYSDIR%\d41mt.hlp 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete d41mt.ini 
@set FILE=%MYWINSYSDIR%\d41mt.ini 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete d41mt.tsp 
@set FILE=%MYWINSYSDIR%\d41mt.tsp 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete d42ntf.dll 
@set FILE=%MYWINSYSDIR%\d42ntf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DCMObj.exe 
@set FILE=%MYWINSYSDIR%\DCMObj.exe 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DCMObjps.dll 
@set FILE=%MYWINSYSDIR%\DCMObjps.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DlgcAtf.dll 
@set FILE=%MYWINSYSDIR%\DlgcAtf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcbric.dll 
@set FILE=%MYWINSYSDIR%\dlgcbric.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcdiag.dll 
@set FILE=%MYWINSYSDIR%\dlgcdiag.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DlgcDk.dll 
@set FILE=%MYWINSYSDIR%\DlgcDk.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DlgcHost.dll 
@set FILE=%MYWINSYSDIR%\DlgcHost.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcOrbUtil.dll 
@set FILE=%MYWINSYSDIR%\dlgcOrbUtil.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcs7srvps.dll
@set FILE=%MYWINSYSDIR%\dlgcs7srvps.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete dlgcSNMP.dll 
@set FILE=%MYWINSYSDIR%\dlgcSNMP.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcSRAMPerf.dll 
@set FILE=%MYWINSYSDIR%\dlgcSRAMPerf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcstopprotocol.dll 
@set FILE=%MYWINSYSDIR%\dlgcstopprotocol.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgServiceResults.dll 
@set FILE=%MYWINSYSDIR%\dlgServiceResults.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgwave.dll 
@set FILE=%MYWINSYSDIR%\dlgwave.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlreg.dll 
@set FILE=%MYWINSYSDIR%\dlreg.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3adl.dll 
@set FILE=%MYWINSYSDIR%\dm3adl.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3autodump.dll 
@set FILE=%MYWINSYSDIR%\dm3autodump.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3be.dll 
@set FILE=%MYWINSYSDIR%\dm3be.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3bsp.dll 
@set FILE=%MYWINSYSDIR%\dm3bsp.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM dm3bsp.log 
@set FILE=%MYWINSYSDIR%\dm3bsp.log 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dm3FaxLib.dll 
@set FILE=%MYWINSYSDIR%\Dm3FaxLib.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3fdsp.dll 
@set FILE=%MYWINSYSDIR%\dm3fdsp.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3leo.dll 
@set FILE=%MYWINSYSDIR%\dm3leo.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dm3Odi.dll 
@set FILE=%MYWINSYSDIR%\Dm3Odi.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dm3OdiUtility.dll 
@set FILE=%MYWINSYSDIR%\Dm3OdiUtility.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dm3Oti.dll 
@set FILE=%MYWINSYSDIR%\Dm3Oti.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dmr4cleo.dll 
@set FILE=%MYWINSYSDIR%\dmr4cleo.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dtintf.dll 
@set FILE=%MYWINSYSDIR%\dtintf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete FruStatus.dll 
@set FILE=%MYWINSYSDIR%\FruStatus.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete frustatus.log 
@set FILE=%MYWINSYSDIR%\frustatus.log 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete genload.dll 
@set FILE=%MYWINSYSDIR%\genload.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete GlfxIf.dll 
@set FILE=%MYWINSYSDIR%\GlfxIf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete GlfxStd.dll 
@set FILE=%MYWINSYSDIR%\GlfxStd.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete HotDll.dll 
@set FILE=%MYWINSYSDIR%\HotDll.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete icudata.dll 
@set FILE=%MYWINSYSDIR%\icudata.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete icuuc.dll 
@set FILE=%MYWINSYSDIR%\icuuc.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete idl405.dll 
@set FILE=%MYWINSYSDIR%\idl405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete idl405d.dll 
@set FILE=%MYWINSYSDIR%\idl405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete imr405.dll 
@set FILE=%MYWINSYSDIR%\imr405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete imr405d.dll 
@set FILE=%MYWINSYSDIR%\imr405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM IPTConf.log 
@set FILE=%MYWINSYSDIR%\IPTConf.log 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete isdnspan.dll 
@set FILE=%MYWINSYSDIR%\isdnspan.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete jtc1014.dll 
@set FILE=%MYWINSYSDIR%\jtc1014.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete jtc1014d.dll 
@set FILE=%MYWINSYSDIR%\jtc1014d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete kvscscu.dll 
@set FILE=%MYWINSYSDIR%\kvscscu.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libadi.dll 
@set FILE=%MYWINSYSDIR%\libadi.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libantmt.dll 
@set FILE=%MYWINSYSDIR%\libantmt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libcspdm3.dll 
@set FILE=%MYWINSYSDIR%\libcspdm3.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libd300mt.dll 
@set FILE=%MYWINSYSDIR%\libd300mt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libd42mt.dll 
@set FILE=%MYWINSYSDIR%\libd42mt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdevmap.dll 
@set FILE=%MYWINSYSDIR%\libdevmap.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdevmgmt.dll 
@set FILE=%MYWINSYSDIR%\libdevmgmt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdevnamedoler.dll 
@set FILE=%MYWINSYSDIR%\libdevnamedoler.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgadminconsumerfw.dll 
@set FILE=%MYWINSYSDIR%\libdlgadminconsumerfw.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgadminconsumerfwd.dll 
@set FILE=%MYWINSYSDIR%\libdlgadminconsumerfwd.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgadminsupplierfw.dll 
@set FILE=%MYWINSYSDIR%\libdlgadminsupplierfw.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgadminsupplierfwd.dll 
@set FILE=%MYWINSYSDIR%\libdlgadminsupplierfwd.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgerrors.dll 
@set FILE=%MYWINSYSDIR%\libdlgerrors.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgoslayer.dll 
@set FILE=%MYWINSYSDIR%\libdlgoslayer.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacadmininterface.dll 
@set FILE=%MYWINSYSDIR%\libdlgpmacadmininterface.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacbsp.dll 
@set FILE=%MYWINSYSDIR%\libdlgpmacbsp.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacdetector.dll 
@set FILE=%MYWINSYSDIR%\libdlgpmacdetector.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacfdsp.dll 
@set FILE=%MYWINSYSDIR%\libdlgpmacfdsp.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacinitializer.dll 
@set FILE=%MYWINSYSDIR%\libdlgpmacinitializer.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacparser.dll 
@set FILE=%MYWINSYSDIR%\libdlgpmacparser.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmactimeslotassigner.dll 
@set FILE=%MYWINSYSDIR%\libdlgpmactimeslotassigner.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacutilities.dll 
@set FILE=%MYWINSYSDIR%\libdlgpmacutilities.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgregister.dll 
@set FILE=%MYWINSYSDIR%\libdlgregister.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgsysloggerclient.dll 
@set FILE=%MYWINSYSDIR%\libdlgsysloggerclient.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdm3cc.dll 
@set FILE=%MYWINSYSDIR%\libdm3cc.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdm3dcb.dll 
@set FILE=%MYWINSYSDIR%\libdm3dcb.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdm3devmgmt.dll 
@set FILE=%MYWINSYSDIR%\libdm3devmgmt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdm3fax.dll 
@set FILE=%MYWINSYSDIR%\libdm3fax.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdm3msi.dll 
@set FILE=%MYWINSYSDIR%\libdm3msi.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdtidm3.dll 
@set FILE=%MYWINSYSDIR%\libdtidm3.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdtimt.dll 
@set FILE=%MYWINSYSDIR%\libdtimt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdxxdm3.dll 
@set FILE=%MYWINSYSDIR%\libdxxdm3.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete LIBDXXMT.dll 
@set FILE=%MYWINSYSDIR%\LIBDXXMT.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libecmt.dll 
@set FILE=%MYWINSYSDIR%\libecmt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libfaxmt.dll 
@set FILE=%MYWINSYSDIR%\libfaxmt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgc.dll 
@set FILE=%MYWINSYSDIR%\libgc.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgcan.dll 
@set FILE=%MYWINSYSDIR%\libgcan.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgch3r.dll 
@set FILE=%MYWINSYSDIR%\libgch3r.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgcipm.dll 
@set FILE=%MYWINSYSDIR%\libgcipm.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgcis.dll 
@set FILE=%MYWINSYSDIR%\libgcis.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgcr2.dll 
@set FILE=%MYWINSYSDIR%\libgcr2.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Libgcs7.dll 
@set FILE=%MYWINSYSDIR%\Libgcs7.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Libipm.dll 
@set FILE=%MYWINSYSDIR%\Libipm.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libipm_fax.dll 
@set FILE=%MYWINSYSDIR%\libipm_fax.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libipm_ipvsc.dll 
@set FILE=%MYWINSYSDIR%\libipm_ipvsc.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libipm_nettsc.dll 
@set FILE=%MYWINSYSDIR%\libipm_nettsc.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libipm_pmac.dll 
@set FILE=%MYWINSYSDIR%\libipm_pmac.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libisdnr4.dll 
@set FILE=%MYWINSYSDIR%\libisdnr4.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete liblmode.dll 
@set FILE=%MYWINSYSDIR%\liblmode.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libs7admin.dll 
@set FILE=%MYWINSYSDIR%\libs7admin.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libmsir4.dll 
@set FILE=%MYWINSYSDIR%\libmsir4.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libpcmt.dll 
@set FILE=%MYWINSYSDIR%\libpcmt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libprds.dll 
@set FILE=%MYWINSYSDIR%\libprds.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libprtms.dll 
@set FILE=%MYWINSYSDIR%\libprtms.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libprtmsnj.dll 
@set FILE=%MYWINSYSDIR%\libprtmsnj.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete librtfmt.dll 
@set FILE=%MYWINSYSDIR%\librtfmt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libsigal.dll 
@set FILE=%MYWINSYSDIR%\libsigal.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libsipsigal.dll 
@set FILE=%MYWINSYSDIR%\libsipsigal.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libsrlmt.dll 
@set FILE=%MYWINSYSDIR%\libsrlmt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libxlog.dll 
@set FILE=%MYWINSYSDIR%\libxlog.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete LicenseManager.dll 
@set FILE=%MYWINSYSDIR%\LicenseManager.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete LMode.dll 
@set FILE=%MYWINSYSDIR%\LMode.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM merc.log 
@set FILE=%MYWINSYSDIR%\merc.log 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete mercconfig.dll 
@set FILE=%MYWINSYSDIR%\mercconfig.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete MM_Fax.dll 
@set FILE=%MYWINSYSDIR%\MM_Fax.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete mnti.dll 
@set FILE=%MYWINSYSDIR%\mnti.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete msintf.dll 
@set FILE=%MYWINSYSDIR%\msintf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NCMAhw.dll 
@set FILE=%MYWINSYSDIR%\NCMAhw.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NCMApi.dll 
@set FILE=%MYWINSYSDIR%\NCMApi.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NCMCconf.dll 
@set FILE=%MYWINSYSDIR%\NCMCconf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NCMData.dll 
@set FILE=%MYWINSYSDIR%\NCMData.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NCMProp.dll 
@set FILE=%MYWINSYSDIR%\NCMProp.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ndi.dll 
@set FILE=%MYWINSYSDIR%\ndi.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NtGdk.dll 
@set FILE=%MYWINSYSDIR%\NtGdk.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NtGdkMsg.dll 
@set FILE=%MYWINSYSDIR%\NtGdkMsg.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ob405.dll 
@set FILE=%MYWINSYSDIR%\ob405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ob405d.dll 
@set FILE=%MYWINSYSDIR%\ob405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBBiDir405.dll 
@set FILE=%MYWINSYSDIR%\OBBiDir405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBBiDir405d.dll 
@set FILE=%MYWINSYSDIR%\OBBiDir405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBEvent405.dll 
@set FILE=%MYWINSYSDIR%\OBEvent405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBEvent405d.dll 
@set FILE=%MYWINSYSDIR%\OBEvent405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBEventService405.dll 
@set FILE=%MYWINSYSDIR%\OBEventService405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBEventService405d.dll 
@set FILE=%MYWINSYSDIR%\OBEventService405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBNaming405.dll 
@set FILE=%MYWINSYSDIR%\OBNaming405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBNaming405d.dll 
@set FILE=%MYWINSYSDIR%\OBNaming405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBNamingService405.dll 
@set FILE=%MYWINSYSDIR%\OBNamingService405.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBNamingService405d.dll 
@set FILE=%MYWINSYSDIR%\OBNamingService405d.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete PBXpert.dll 
@set FILE=%MYWINSYSDIR%\PBXpert.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete PBXpertWizard.dll 
@set FILE=%MYWINSYSDIR%\PBXpertWizard.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pdi.dll
@set FILE=%MYWINSYSDIR%\pdi.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pdkrt.dll
@set FILE=%MYWINSYSDIR%\pdkrt.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pmac_transport.dll 
@set FILE=%MYWINSYSDIR%\pmac_transport.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pmacadl.dll 
@set FILE=%MYWINSYSDIR%\pmacadl.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pnpapi.dll 
@set FILE=%MYWINSYSDIR%\pnpapi.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete prtmsspan.dll 
@set FILE=%MYWINSYSDIR%\prtmsspan.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete r4bsp.dll 
@set FILE=%MYWINSYSDIR%\r4bsp.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete RNCMapi.dll 
@set FILE=%MYWINSYSDIR%\RNCMapi.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rv32h323.dll 
@set FILE=%MYWINSYSDIR%\rv32h323.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rv32rtp.dll 
@set FILE=%MYWINSYSDIR%\rv32rtp.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvasn1.dll 
@set FILE=%MYWINSYSDIR%\rvasn1.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvcommon.dll 
@set FILE=%MYWINSYSDIR%\rvcommon.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvcore.dll 
@set FILE=%MYWINSYSDIR%\rvcore.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvsdp.dll 
@set FILE=%MYWINSYSDIR%\rvsdp.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvsip.dll 
@set FILE=%MYWINSYSDIR%\rvsip.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete S7Cfg.dll 
@set FILE=%MYWINSYSDIR%\S7Cfg.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete SCEventMsg.dll 
@set FILE=%MYWINSYSDIR%\SCEventMsg.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete sdntf.dll
@set FILE=%MYWINSYSDIR%\sdntf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete SnmpConfigUtility.exe 
@set FILE=%MYWINSYSDIR%\SnmpConfigUtility.exe 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete SoftFaxRM.dll 
@set FILE=%MYWINSYSDIR%\SoftFaxRM.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete sramperf.dll 
@set FILE=%MYWINSYSDIR%\sramperf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete sse.dll 
@set FILE=%MYWINSYSDIR%\sse.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete supserve.dll 
@set FILE=%MYWINSYSDIR%\supserve.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete swadl.dll 
@set FILE=%MYWINSYSDIR%\swadl.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete swfdsp.dll 
@set FILE=%MYWINSYSDIR%\swfdsp.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete tcutil.dll 
@set FILE=%MYWINSYSDIR%\tcutil.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete syntellect.dll 
@set FILE=%MYWINSYSDIR%\syntellect.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete tascscu.dll 
@set FILE=%MYWINSYSDIR%\tascscu.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ThirdPartyBsp.dll 
@set FILE=%MYWINSYSDIR%\ThirdPartyBsp.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ThirdPartyDetector.dll 
@set FILE=%MYWINSYSDIR%\ThirdPartyDetector.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete vfxntf.dll 
@set FILE=%MYWINSYSDIR%\vfxntf.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete voxspan.dll 
@set FILE=%MYWINSYSDIR%\voxspan.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete xerces-c_1_1.dll 
@set FILE=%MYWINSYSDIR%\xerces-c_1_1.dll 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM
REM
REM Delete files from %MYWINDRIVERSDIR% 
REM
REM

REM Delete AntDetect.sys 
@set FILE=%MYWINDRIVERSDIR%\AntDetect.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete BrgRes.sys 
@set FILE=%MYWINDRIVERSDIR%\BrgRes.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete apicdrv.sys
@set FILE=%MYWINDRIVERSDIR%\apicdrv.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DlgcAntares.sys 
@set FILE=%MYWINDRIVERSDIR%\DlgcAntares.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcbri.sys 
@set FILE=%MYWINDRIVERSDIR%\dlgcbri.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgccore.sys 
@set FILE=%MYWINDRIVERSDIR%\dlgccore.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcdcm.sys 
@set FILE=%MYWINDRIVERSDIR%\dlgcdcm.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcmcd.sys 
@set FILE=%MYWINDRIVERSDIR%\dlgcmcd.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcmpd.sys 
@set FILE=%MYWINDRIVERSDIR%\dlgcmpd.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgchpet.sys 
@set FILE=%MYWINDRIVERSDIR%\dlgchpet.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcsram.sys 
@set FILE=%MYWINDRIVERSDIR%\dlgcsram.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcupgrade.sys 
@set FILE=%MYWINDRIVERSDIR%\dlgcupgrade.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DM3InsightDrv.sys 
@set FILE=%MYWINDRIVERSDIR%\DM3InsightDrv.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dm3nk.sys
@set FILE=%MYWINDRIVERSDIR%\Dm3nk.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete glfxisa.sys 
@set FILE=%MYWINDRIVERSDIR%\glfxisa.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete glfxpci.sys 
@set FILE=%MYWINDRIVERSDIR%\glfxpci.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete gloaddrv.sys 
@set FILE=%MYWINDRIVERSDIR%\gloaddrv.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete KMBC.sys
@set FILE=%MYWINDRIVERSDIR%\kmbc.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete smtkstub.dll
@set FILE=%MYWINDRIVERSDIR%\smtkstub.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ssp.mlm.sys
@set FILE=%MYWINDRIVERSDIR%\ssp.mlm.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete sspIntf.sys
@set FILE=%MYWINDRIVERSDIR%\sspIntf.sys 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete wdm_ant.inf 
@set FILE=%MYWINDRIVERSDIR%\wdm_ant.inf 
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pcd.sys 
@set FILE=%MYWINDRIVERSDIR%\pcd.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pcdd.sys 
@set FILE=%MYWINDRIVERSDIR%\pcdd.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pmac_wdm.inf
@set FILE=%MYWININFDIR%\pmac_wdm.inf
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ppd.sys
@set FILE=%MYWINDRIVERSDIR%\ppd.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ppdd.sys
@set FILE=%MYWINDRIVERSDIR%\ppdd.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete wdfdlgcjct.sys
@set FILE=%MYWINDRIVERSDIR%\wdfdlgcjct.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dialogic files from c:\winnt\inf\oem*.inf
REM Checking for oem*.inf files to delete.
@for %%i in ("%MYWININFDIR%\oem*.inf") do @call:RM_OEM "%%i"

@REM ---------------------------------------------------------------
@REM skip over this subroutine.  It should only be CALLed
@GOTO :RM_OEM_SKIP
@REM ---------------------------------------------------------------
:RM_OEM
@REM this label should be CALLed with a single parameter which
@REM is the name of a file name to delete if it is one of ours.
@REM -
@REM We'll check the contents of the file passed as the first param
@REM for some special strings.  If those strings exist in the file
@REM then it will need to be deleted.

@REM in order not to remove the Diva server inf file, which also contains name
@REM Dialogic, we check if file contains "Diva" string and skip such file
find /I /C "diva" %1 > NUL
@If Errorlevel 0 SET ERRLEV=0
@If Errorlevel 1 SET ERRLEV=1
@if "%ERRLEV%" == "0" GOTO :RM_OEM_NO_DELETE

@REM check if file contains "dialogic" string
find /I /C "dialogic" %1 > NUL
@If Errorlevel 0 SET ERRLEV=0
@If Errorlevel 1 SET ERRLEV=1
@if "%ERRLEV%" == "0" GOTO :RM_OEM_DELETE

@REM check if file contains "NetStructure" string 
@find /I /C "Intel NetStructure" %1 > NUL
@If Errorlevel 0 SET ERRLEV=0
@If Errorlevel 1 SET ERRLEV=1
@if "%ERRLEV%" == "0" GOTO :RM_OEM_DELETE

@REM if get here then nothing to delete so jump over delete.
@GOTO :RM_OEM_NO_DELETE

:RM_OEM_DELETE
@REM do the deletion here
@echo deleting file %~1
@set FILE=%~1
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM check for corresponding .pnf file and delete if exists
@set FILE=%~d1%~p1%~n1.pnf
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"


:RM_OEM_NO_DELETE

@REM This goto is the last command in the RM_OEM function.
@REM Goto end of file really just returns from call 
@goto :EOF
@REM ---------------------------------------------------------------
:RM_OEM_SKIP
@REM ---------------------------------------------------------------


@REM
@REM The following code generates a registry file which, when run
@REM will delete various keys which were not removed by the uninstall.
@REM
REM
REM Generating temporary file containing list of registry keys to be removed
REM

@set DIALOGICREGPTH=%DIALOGICDIR:\=\\%

@set WINSYSREGPTH=%MYWINSYSDIR:\=\\%

@set WINDRVREGPTH=%MYWINDRIVERSDIR:\=\\%


:mkregfile
if exist "%TEMP%\dlgc_reg_clean.reg" del /f "%TEMP%\dlgc_reg_clean.reg"
@echo REGEDIT4>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Dialogic key hierarchy is common to all releases>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### GammaLink still writes config information outside the Dialogic hierarchy>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\GammaLink]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Control Panel\Cpls]>> %TEMP%\dlgc_reg_clean.reg
@echo "ConfigGamma"=->> %TEMP%\dlgc_reg_clean.reg
@echo "ConfigGDK"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Global Call Protocols 3.0 and earlier>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Intel Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### SNMP support>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Intel\Dialogic SNMP]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### From the SR Win 6.0 cPCI FP1 release>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\INTEL\Intel(R) Dialogic(R) System Release 6.0 cPCI Feature Pack 1 for Windows]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### These keys were used in very old releases>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\Dialogic System Release]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\DialogicR4X]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Intel Dialogic services>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # CurrentControlSet>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\AnmChannelFactoryServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\AnmChannelServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\AnmLoggerServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\AnmSupplierServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\AntDetect]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Boardserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DebugAngel]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcAntares]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Dlgcmcd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Dlgchpet]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcS7Srv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcSram]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcUpgrade]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\dlgH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DM3InsightDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\EventService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\GlfxIsa]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\GlfxPci]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Gloaddrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\IMRService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NamingService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\RtfDispatcher]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Springware_temp]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\INTEL HMP License Manager]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\INTEL HMP Media Server]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet001>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\AnmChannelFactoryServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\AnmChannelServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\AnmLoggerServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\AnmSupplierServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\AntDetect]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Boardserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DebugAngel]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcAntares]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Dlgcmcd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Dlgchpet]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcS7Srv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcSram]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcUpgrade]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\dlgH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DM3InsightDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\EventService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\GlfxIsa]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\GlfxPci]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Gloaddrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\IMRService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\NamingService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\RtfDispatcher]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Springware_temp]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\INTEL HMP License Manager]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\INTEL HMP Media Server]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet002>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\AnmChannelFactoryServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\AnmChannelServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\AnmLoggerServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\AnmSupplierServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\AntDetect]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Boardserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DebugAngel]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcAntares]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Dlgcmcd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Dlgchpet]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcS7Srv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcSram]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcUpgrade]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\dlgH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DM3InsightDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\EventService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\GlfxIsa]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\GlfxPci]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Gloaddrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\IMRService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\NamingService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\RtfDispatcher]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Springware_temp]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\INTEL HMP License Manager]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\INTEL HMP Media Server]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Intel Dialogic SNMP Extension agents>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # CurrentControlSet>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP\Parameters\ExtensionAgents]>> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_HWAGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_PERFINFO"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_R4AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_ISDN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_T1E1AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_DM3EXTPLAT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicPerformanceAgent"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicSNMPAgent"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet001>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\SNMP\Parameters\ExtensionAgents]>> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_HWAGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_PERFINFO"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_R4AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_ISDN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_T1E1AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_DM3EXTPLAT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicPerformanceAgent"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicSNMPAgent"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet002>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\SNMP\Parameters\ExtensionAgents]>> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_HWAGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_PERFINFO"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_R4AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_ISDN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_T1E1AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_DM3EXTPLAT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicPerformanceAgent"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicSNMPAgent"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Legacy keys can't be deleted until security permissions are changed>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # CurrentControlSet>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\DIALOGIC_CP_FAX_DEVICES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ANMCHANNELFACTORYSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ANMCHANNELSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ANMLOGGERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ANMSUPPLIERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ANTDETECT]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_BOARDSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_BRGRES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_CPV8540]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_CTBUSBROKER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DEBUGANGEL]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DETECTORSPROJ]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DIALOGIC]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCDCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCDEVICEMAPPER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCMCD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCMPD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGPNPOBSERVERSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCSRAM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCUPGRADE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DM3CONFIG]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DM3INSIGHTDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_EVENTSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_FORCE731]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_GLFXISA]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_GLFXPCI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_GLOADDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_HSPCIMSG]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_IMRSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_NAMINGSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_PCIHOTSWAPDRIVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_RTFDISPATCHER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ZT554X]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet001>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\DIALOGIC_CP_FAX_DEVICES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ANMCHANNELFACTORYSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ANMCHANNELSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ANMLOGGERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ANMSUPPLIERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ANTDETECT]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_BOARDSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_BRGRES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_CPV8540]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_CTBUSBROKER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DEBUGANGEL]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DETECTORSPROJ]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DIALOGIC]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCDCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCDEVICEMAPPER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCMCD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCMPD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGPNPOBSERVERSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCSRAM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCUPGRADE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DM3CONFIG]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DM3INSIGHTDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_EVENTSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_FORCE731]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_GLFXISA]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_GLFXPCI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_GLOADDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_HSPCIMSG]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_IMRSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_NAMINGSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_PCIHOTSWAPDRIVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_RTFDISPATCHER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ZT554X]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet002>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\DIALOGIC_CP_FAX_DEVICES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANMCHANNELFACTORY]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANMCHANNELFACTORYSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANMCHANNELSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANMLOGGERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANMSUPPLIERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANTDETECT]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_BOARDSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_BRGRES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_CPV8540]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_CTBUSBROKER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DEBUGANGEL]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DETECTORSPROJ]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DIALOGIC]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCDCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCDEVICEMAPPER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCMCD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCMPD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGPNPOBSERVERSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCSRAM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCUPGRADE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DM3CONFIG]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DM3INSIGHTDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_EVENTSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_FORCE731]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_GLFXISA]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_GLFXPCI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_GLOADDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_HSPCIMSG]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_IMRSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_NAMINGSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_PCIHOTSWAPDRIVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_RTFDISPATCHER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ZT554X]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### ANM>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\AppID\AnmChannelFactoryServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\AnmChannelFactoryServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\AppID\AnmChannelServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\AnmChannelServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\AppID\AnmLoggerServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\AnmLoggerServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\AppID\AnmSupplierServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\AnmSupplierServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### DlgcS7Srv Service>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\AppID\DlgcS7Srv.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\DlgcS7Srv.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\AppID\{78D5DEE1-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\{78D5DEE1-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\DlgcS7Srv.DlgcS7Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DlgcS7Srv.DlgcS7Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\DlgcS7Srv.DlgcS7Config.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DlgcS7Srv.DlgcS7Config.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\DlgcS7Srv.DlgcS7ProcSession]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DlgcS7Srv.DlgcS7ProcSession]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\DlgcS7Srv.DlgcS7ProcSession.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DlgcS7Srv.DlgcS7ProcSession.1]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo #####	DCMObj >> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\{C463BA48-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\DCMObj.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DCM.DCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DCM.DCM.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Dm3Detector.Dm3Detector]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Dm3Detector.Dm3Detector.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{F09F3850-BC92-11D3-B4A0-00104B2B2DCF}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo #####	DetectorsProj>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\AppID\DetectorsProj.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\DetectorsProj.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\{3AA32E53-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo #####	INTERFACE CLASSES>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ILoggerServer>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{1B0FE3BF-A2A7-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{1B0FE3BF-A2A7-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IAnmBaseMsg>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{35DC75AD-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{35DC75AD-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IBaseDetector>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{3AA32E5F-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDM3Detector>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{3AA32E60-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ILogMsg>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{35DC75B0-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{35DC75B0-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDlgcS7ProcSession>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{78D5DEED-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{78D5DEED-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDlgcS7HostCallBack>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{78D5DEF0-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{78D5DEF0-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDlgcS7HostSession>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{78D5DEF2-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{78D5DEF2-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDlgcS7TsAssigner>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{78D5DEF4-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{78D5DEF4-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDlgcS7TelephonyConfig>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{78D5DEF6-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{78D5DEF6-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IPMACDetector>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{A0A08F03-2C6E-47DC-8D4E-0102548C50CD}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDCM>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{C463BA56-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{C463BA56-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ISPWDetector>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{C5F00682-1A03-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IAnmChannelFactory>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{F3D330CF-A2A1-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{F3D330CF-A2A1-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IAnmChannelServer>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{6E131B4F-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{6E131B4F-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IConsumerEnumCO>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{6E131B51-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{6E131B51-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IAnmSupplierServer>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{6E131B5F-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{6E131B5F-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IAnmConsumerServer>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\Interface\{7773D9DE-6BAB-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{7773D9DE-6BAB-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo #####	Class Type Libraries>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmLoggerServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\TypeLib\{1B0FE3B2-A2A7-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{1B0FE3B2-A2A7-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmMsgServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\TypeLib\{35DC75A0-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{35DC75A0-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # DetectorsProj 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\TypeLib\{3AA32E52-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{3AA32E52-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmChannelServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\TypeLib\{6E131B42-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{6E131B42-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmSupplierServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\TypeLib\{6E131B52-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{6E131B52-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmConsumerServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\TypeLib\{7773D9D1-6BAB-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{7773D9D1-6BAB-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # DlgcS7Srv 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\TypeLib\{78D5DEE0-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{78D5DEE0-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # DCMObj 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\TypeLib\{C463BA47-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{C463BA47-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmChannelFactoryServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\TypeLib\{F3D330C2-A2A1-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{F3D330C2-A2A1-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### shared DLL's both in Dialogic directory and in system32>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\SharedDLLs]>> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%bin\\DCMObj.exe"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\brintf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\cheetah.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\ctbbface.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\DCMObjps.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\dlgcdiag.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\DlgcDk.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\dlgServiceResults.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\dm3be.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\dm3bsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\dm3fdsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\dm3leo.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\Dm3Odi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\Dm3OdiUtility.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\Dm3Oti.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\dmr4cleo.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\FruStatus.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\GENLOAD.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\isdnspan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libcspdm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libd42mt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libdm3cc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libdm3dcb.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libdm3fax.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libdm3msi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libdtidm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libdtimt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libdxxdm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\LIBDXXMT.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libecmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libfaxmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libgc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libgcan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libgcipm.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libgcis.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libgcr2.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\Libgcs7.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\Libipm.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libipm_ipvsc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libipm_nettsc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libisdnr4.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libmsir4.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\libsrlmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\mercconfig.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\mnti.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\msintf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\NCMAhw.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\NCMApi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\NCMCconf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\NCMData.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\NCMProp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\PBXpert.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\pdkrt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\r4bsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\RNCMapi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\rv32h323.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\S7Cfg.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\voxspan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPTH%lib\\xerces-c_1_1.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%brintf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%cheetah.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%ctbbface.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%DCMObjps.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%dlgcdiag.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%DlgcDk.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%dlgServiceResults.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%dm3be.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%dm3bsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%dm3fdsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%dm3leo.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%Dm3Odi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%Dm3OdiUtility.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%Dm3Oti.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%Dmr4cleo.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%FruStatus.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%GENLOAD.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%isdnspan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libcspdm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libd42mt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libdm3cc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libdm3dcb.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libdm3fax.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libdm3msi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libdtidm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libdtimt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libdxxdm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%LIBDXXMT.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libecmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libfaxmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libgc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libgcan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libgcipm.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libgcis.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libgcr2.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%Libgcs7.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%Libipm.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libipm_ipvsc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libipm_nettsc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libisdnr4.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libmsir4.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%libsrlmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%mercconfig.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%mnti.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%msintf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%NCMAhw.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%NCMApi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%NCMCconf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%NCMData.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%NCMProp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%PBXpert.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%pdkrt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%r4bsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%RNCMapi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%rv32h323.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%S7Cfg.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%voxspan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%xerces-c_1_1.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%ConfigGamma.cpl"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%ConfigGDK.cpl"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%GlfxIf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%GlfxStd.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%NtGdk.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPTH%NtGdkMsg.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo #####	CLSIDs>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # PMACDetector.PMACDetector.1 >> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{0815E881-19DF-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\CLSID\{0815E881-19DF-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # SPWDetector.SPWDetector.1 >> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{0815E883-19DF-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\CLSID\{0815E883-19DF-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # DCM.DCM.1>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{C463BA58-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\CLSID\{C463BA58-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # C:\Program Files\Dialogic\lib\dcmobjps.dll>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{F09F3850-BC92-11D3-B4A0-00104B2B2DCF}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\CLSID\{F09F3850-BC92-11D3-B4A0-00104B2B2DCF}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # C:\Program Files\Dialogic\bin\DetectorsServer.exe>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{3AA32E52-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\TypeLib\{3AA32E52-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # C:\Program Files\Dialogic\bin\DlgcS7Srvps.dll>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\CLSID\{78D5DEED-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{78D5DEED-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # C:\Program Files\Dialogic\bin\DlgcS7~1.exe>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\CLSID\{78D5DEEE-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{78D5DEEE-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\CLSID\{78D5DEF5-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{78D5DEF5-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # SetupLogServices Class>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Classes\CLSID\{8c3c1b17-e59d-11d2-b40b-00a024b9dddd}]0>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Start Menu Item>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel Dialogic System Release 6.0 PCI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel Dialogic System Software]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel Dialogic System Release]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel HMP 1.0]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel NetStructure (TM) HMP 1.0 menu]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel HMP 1.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel NetStructure HMP]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Install GUIDs>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Win 6.0 cPCI FP1>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{D43962D0-77A0-11D4-8F9D-00C04F35CB28}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Point Releases>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{0FC1D5E3-21B9-11D4-A580-00C04F35CB28}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Feature and Old Service Packs>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{E62BF0D9-BA88-4227-B079-F2E52100E446}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Service Packs (SR 5.1.1 SP3 and later)>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{18D1CB58-7334-41BA-85BF-EF31C321CEBC}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### SR 6.0 Runtime>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{4A6FA71B-C3AA-494D-8D5D-6B5A3C196946}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### HMP 1.0 and 1.1 Runtime>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{DF2FE966-3A24-429D-B11C-1AB13E2AD6D0}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### HMP HMP 1.0 SP1 and FP1 Runtime>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{0FC1D5E3-21B9-11D4-A580-00C04F35CB28}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### HMP 1.1SU Runtime>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{E62BF0D9-BA88-4227-B079-F2E52100E446}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### HMP 1.3, 1.3SU, 2.0 and 2.0SU Runtime>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{4A6FA71B-C3AA-494D-8D5D-6B5A3C196946}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### SR 6.0 SDK (obsolete, never released)>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{57A6B857-C948-427F-979C-CB8AF5331A56}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Global Call Protocols 3.0 and earlier>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\Global Call Protocols]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Global Call Protocols 4.0 and later>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\{8C1C7C31-AE1E-4EA9-A108-80F23ED7AE1B}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\Uninstall\Intel Dialogic Global Call Protocols]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Install setup.exe path>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\App Paths\setup.exe]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Dialogic and Intel Dialogic environment variables>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # CurrentControlSet>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment]>> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDRV"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICSNMPDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLCFGPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLFWLPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_TRACE_LEVEL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLGCDESTDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLINFPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DNASDKDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BIN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CFG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_FWL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_INC"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_LIB"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_NAME"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_QSCRIPT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_RELEASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "ORBACUS_CONFIG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "QSCRIPT_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "GFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CPFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGIC_CFG_INTERNAL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGIC_FWL_BIN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGIC_USERDATA_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet001>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Session Manager\Environment]>> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDRV"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICSNMPDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLCFGPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLFWLPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_TRACE_LEVEL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLGCDESTDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLINFPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DNASDKDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BIN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CFG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_FWL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_INC"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_LIB"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_NAME"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_QSCRIPT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_RELEASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "ORBACUS_CONFIG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "QSCRIPT_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "GFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CPFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGIC_CFG_INTERNAL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGIC_FWL_BIN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGIC_USERDATA_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet002>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Session Manager\Environment]>> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDRV"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICSNMPDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLCFGPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLFWLPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_TRACE_LEVEL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLGCDESTDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLINFPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DNASDKDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BIN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CFG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_FWL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_INC"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_LIB"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_NAME"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_QSCRIPT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_RELEASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "ORBACUS_CONFIG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "QSCRIPT_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "QSCRIPT_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "GFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CPFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGIC_CFG_INTERNAL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGIC_FWL_BIN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGIC_USERDATA_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ### TO-DO: Remove Dialogic directories from the path.  Can't do with reg file!>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Event Logger tie-ins>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # CurrentControlSet>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application\Implementation Repository]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\Busfiltr]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\Dlgc_log]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\dm3bsp]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DM3Detector]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet001>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\Application\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\Application\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\Application\Implementation Repository]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\Busfiltr]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\Dlgc_log]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\dm3bsp]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DM3Detector]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet002>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\Application\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\Application\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\Application\Implementation Repository]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\Busfiltr]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\Dlgc_log]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\dm3bsp]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DM3Detector]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Driver-related>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # PCIHotSwapDriver>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{4EC32020-5104-11D2-8B4D-0080ADB72206}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Class\{4EC32020-5104-11D2-8B4D-0080ADB72206}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Class\{4EC32020-5104-11D2-8B4D-0080ADB72206}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DeviceClasses\{4ec32020-5104-11d2-8b4d-0080adb72206}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DeviceClasses\{4ec32020-5104-11d2-8b4d-0080adb72206}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DeviceClasses\{4ec32020-5104-11d2-8b4d-0080adb72206}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # Intel NetStructure DM/HDSI Devices>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Class\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Class\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DeviceClasses\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DeviceClasses\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DeviceClasses\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # Dialogic SpringWare Devices>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Class\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Class\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DeviceClasses\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DeviceClasses\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DeviceClasses\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # Dialogic CP Fax Devices>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Class\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Class\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DeviceClasses\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DeviceClasses\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DeviceClasses\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # PMAC Devices>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Class\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Class\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DeviceClasses\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DeviceClasses\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DeviceClasses\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### WDM Driver performance entries>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\WBEM\WDM]>> %TEMP%\dlgc_reg_clean.reg
@echo "%WINDRVREGPTH%dlgcmcd.sys[MofResourceName]"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINDRVREGPTH%dlgcmpd.sys[MofResourceName]"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\WBEM\WDM\DREDGE]>> %TEMP%\dlgc_reg_clean.reg
@echo "%WINDRVREGPTH%dlgcmcd.sys[MofResourceName]"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINDRVREGPTH%dlgcmpd.sys[MofResourceName]"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Misc>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # DialCfg>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DialCfg]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DialCfg]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DialCfg]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # PMACDetector related>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\PMACDetector.PMACDetector]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\PMACDetector.PMACDetector.1]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # SPWDetector related>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\SPWDetector.SPWDetector]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\SPWDetector.SPWDetector.1]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_USERS\.DEFAULT\SOFTWARE%MYWOW%\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\SOFTWARE%MYWOW%\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SOFTWARE%MYWOW%\Microsoft\Windows\CurrentVersion\RunOnce]>> %TEMP%\dlgc_reg_clean.reg
@echo "DlgcNotRebooted"=->> %TEMP%\dlgc_reg_clean.reg
REM
REM   Temporary registry file generation is complete
REM

REM
REM	Verify that regedit.exe is on the system.  If not,
REM	abort the cleanup and leave the generated registry
REM	file so it can be manually run.
@if exist %REGEDIT% goto found_regedit 
@echo FATAL ERROR:
@echo FATAL ERROR: %REGEDIT% not found.  Registry cleanup aborted.
@echo FATAL_ERROR: Please install %REGEDIT% and run
@echo FATAL_ERROR: "regedit.exe /s %TEMP%\dlgc_reg_clean.reg"
@echo FATAL ERROR: 
@echo.
@REM pause so the user can see the fatal error.
@if not "%NOPROMPT%"=="1" pause
@REM abort but leave .reg file in %TEMP% so user can run it.
@goto end

:found_regedit
REM
REM   Now run the generated registry file
REM   which will delete most of the remaining keys.
REM
if exist %TEMP%\dlgc_reg_clean.reg %REGEDIT% /s %TEMP%\dlgc_reg_clean.reg
@if errorlevel 1 goto regerror
@if errorlevel 0 echo Registry cleanup was successful.
REM For 64 bit Clean up of the non Wow Dialogic Registry
@IF %MYARCH% == x64 (
@IF DEFINED MYWOW (
@set MYWOW=
@goto mkregfile
))
@goto finish

:regerror
@echo Initial execution of registry cleanup failed.  Retrying...
%REGEDIT% /s %TEMP%\dlgc_reg_clean.reg
if errorlevel 1 goto regerror2 
if errorlevel 0 goto finish

:regerror2
@echo FATAL ERROR:
@echo FATAL ERROR: Second execution of registry cleanup failed.
@echo FATAL ERROR: Please manually run %REGEDIT% /s %TEMP%\dlgc_reg_clean.reg
@echo FATAL ERROR:
@if not "%NOPROMPT%"=="1" pause
goto e

:finish
REM
REM Delete the generated registry file
REM
if exist %TEMP%\dlgc_reg_clean.reg del %TEMP%\dlgc_reg_clean.reg

REM
REM Clean-up is complete.
REM

:end
@REM return to the original drive and directory called from
%MYORGDRV%
@cd %MYORGPWD%

REM Delete ourself if the caller asked us to
@if "%DELETESELF%"=="1" if exist "%SELF%" del /f "%SELF%" >NUL 2>NUL